/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.launching;

import com.aptana.php.debug.core.launch.DebugPortNotificationDialog;
import com.aptana.php.debug.core.launch.ScriptLocator;
import com.aptana.php.debug.core.tunneling.SSHTunnel;
import com.aptana.php.debug.core.tunneling.SSHTunnelFactory;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WebBrowserView;
import org2.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org2.eclipse.php.internal.debug.core.Logger;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org2.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org2.eclipse.php.internal.debug.core.xdebug.communication.XDebugCommunicationDaemon;
import org2.eclipse.php.internal.debug.core.zend.communication.DebugConnectionThread;
import org2.eclipse.php.internal.debug.core.zend.communication.DebuggerCommunicationDaemon;
import org2.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;

public class PHPLaunchUtilities {
    private static final String APTANA_PERSPECTIVE = "com.aptana.ide.js.ui.WebPerspective";
    public static final String ID_PHPDebugOutput = "org.eclipse.debug.ui.PHPDebugOutput";
    public static final String ID_PHP_BROWSER_OUTPUT = "org.eclipse.debug.ui.PHPBrowserOutput";
    private static final String SWITCH_BACK_TO_PREVIOUS_PERSPECTIVE = "switchBackToPHPPerspective";
    protected static final String ALLOW_MULTIPLE_LAUNCHES = "allowMultipleLaunches";
    private static DebuggerDelayProgressMonitorDialog progressDialog;
    private static PerspectiveTracker perspectiveTracker;

    static {
        perspectiveTracker = new PerspectiveTracker();
    }

    public static void showDebugViews() {
        if (!PHPDebugEPLPlugin.getOpenDebugViewsOption()) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page != null) {
                    try {
                        IViewPart browserOutputPart = page.findView(PHPLaunchUtilities.ID_PHP_BROWSER_OUTPUT);
                        if (browserOutputPart == null && !page.isPartVisible((IWorkbenchPart)browserOutputPart)) {
                            page.showView(PHPLaunchUtilities.ID_PHP_BROWSER_OUTPUT);
                        }
                    }
                    catch (Exception e) {
                        Logger.logException("Error switching to the Browser Output view", e);
                    }
                }
            }
        });
    }

    public static ISecurePreferences getSecurePreferences(String host) {
        String hostPath = "";
        if (host != null) {
            hostPath = String.valueOf('/') + host;
        }
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = root.node("/com/aptana/ide/php.debug" + hostPath);
        return node;
    }

    public static boolean hasPHPDebugLaunch() {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int i = 0;
        while (i < launches.length) {
            if (!launches[i].isTerminated() && "debug".equals(launches[i].getLaunchMode()) && launches[i].getDebugTarget() instanceof PHPDebugTarget) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean notifyPreviousLaunches(ILaunch newLaunch) throws CoreException {
        if (!"debug".equals(newLaunch.getLaunchMode())) {
            return true;
        }
        if (!PHPLaunchUtilities.hasPHPDebugLaunch()) {
            return true;
        }
        final IPreferenceStore store = PHPDebugEPLPlugin.getDefault().getPreferenceStore();
        String option = store.getString(ALLOW_MULTIPLE_LAUNCHES);
        if ("always".equals(option)) {
            return true;
        }
        if ("never".equals(option)) {
            final Display disp = Display.getDefault();
            disp.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)disp.getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_phpLaunchTitle, (String)PHPDebugCoreMessages.PHPLaunchUtilities_activeLaunchDetected);
                }
            });
            return false;
        }
        final DialogResultHolder resultHolder = new DialogResultHolder();
        final Display disp = Display.getDefault();
        disp.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)disp.getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)PHPDebugCoreMessages.PHPLaunchUtilities_multipleLaunchesPrompt, (String)PHPDebugCoreMessages.PHPLaunchUtilities_rememberDecision, (boolean)false, (IPreferenceStore)store, (String)PHPLaunchUtilities.ALLOW_MULTIPLE_LAUNCHES);
                resultHolder.setReturnCode(m.getReturnCode());
            }
        });
        switch (resultHolder.getReturnCode()) {
            case 0: 
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    public static void switchToPHPPerspective() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IPerspectiveDescriptor currentPerspective = perspectiveTracker.getCurrentPerspective();
                if (currentPerspective != null && !"org.eclipse.debug.ui.DebugPerspective".equals(currentPerspective.getId())) {
                    perspectiveTracker.reset();
                    return;
                }
                String perspectiveID = PHPLaunchUtilities.APTANA_PERSPECTIVE;
                IPerspectiveDescriptor previousPerspective = perspectiveTracker.getPreviousPerspective();
                if (previousPerspective == null) {
                    perspectiveTracker.reset();
                    return;
                }
                perspectiveTracker.reset();
                if (!"org.eclipse.debug.ui.DebugPerspective".equals(previousPerspective.getId())) {
                    perspectiveID = previousPerspective.getId();
                }
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (PHPLaunchUtilities.shouldSwitchToPreviousPerspective(perspectiveID)) {
                    try {
                        workbench.showPerspective(perspectiveID, window);
                    }
                    catch (WorkbenchException e) {
                        Logger.logException(e);
                    }
                }
            }
        });
    }

    private static boolean shouldSwitchToPreviousPerspective(String perspectiveID) {
        IPreferenceStore store = PHPDebugEPLPlugin.getDefault().getPreferenceStore();
        String option = store.getString(SWITCH_BACK_TO_PREVIOUS_PERSPECTIVE);
        if ("always".equals(option)) {
            return true;
        }
        if ("never".equals(option)) {
            return false;
        }
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor perspective = registry.findPerspectiveWithId(perspectiveID);
        if (perspective == null) {
            return false;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IPerspectiveDescriptor current;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (current = page.getPerspective()) != null && current.getId().equals(perspectiveID)) {
                return false;
            }
            MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_PHPPerspectiveSwitchTitle, (String)NLS.bind((String)PHPDebugCoreMessages.PHPLaunchUtilities_PHPPerspectiveSwitchMessage, (Object[])new String[]{perspective.getLabel()}), (String)PHPDebugCoreMessages.PHPLaunchUtilities_rememberDecision, (boolean)false, (IPreferenceStore)store, (String)SWITCH_BACK_TO_PREVIOUS_PERSPECTIVE);
            int result = m.getReturnCode();
            switch (result) {
                case 0: 
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean checkDebugAllPages(ILaunchConfiguration newLaunchConfiguration, final ILaunch newLaunch) throws CoreException {
        if (PHPDebugEPLPlugin.supportsMultipleDebugAllPages()) {
            return true;
        }
        newLaunch.setAttribute("debugPages", newLaunchConfiguration.getAttribute("debugPages", "debugAllPages"));
        PHPLaunchUtilities.checkAutoRemoveLaunches();
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        boolean hasContiniousLaunch = false;
        int i = 0;
        while (!hasContiniousLaunch && i < launches.length) {
            ILaunch launch = launches[i];
            if (launch != newLaunch && "debug".equals(launch.getLaunchMode()) && (PHPLaunchUtilities.isDebugAllPages(launch) || PHPLaunchUtilities.isStartDebugFrom(launch))) {
                hasContiniousLaunch = true;
            }
            ++i;
        }
        boolean newLaunchIsDebug = "debug".equals(newLaunch.getLaunchMode());
        final boolean newIsDebugAllPages = newLaunchIsDebug && PHPLaunchUtilities.isDebugAllPages(newLaunch);
        boolean newIsStartDebugFrom = newLaunchIsDebug && PHPLaunchUtilities.isStartDebugFrom(newLaunch);
        final boolean fHasContiniousLaunch = hasContiniousLaunch;
        if ((fHasContiniousLaunch || newIsDebugAllPages || newIsStartDebugFrom) && launches.length > 1) {
            final DialogResultHolder resultHolder = new DialogResultHolder();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (fHasContiniousLaunch) {
                        resultHolder.setResult(MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)"A previous launch with 'Debug All Pages' or 'Start Debug From' attribute was identifed.\nLaunching a new session will terminate and remove the old launch, directing all future debug requests associated with it to the new launch.\nDo you wish to continue and launch a new session?"));
                    } else if (newIsDebugAllPages) {
                        resultHolder.setResult(MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)"The requested launch has a 'Debug All Pages' attribute.\nLaunching this type of session will terminate and remove any other previous launches.\nDo you wish to continue and launch the new session?"));
                    } else {
                        resultHolder.setResult(MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)"The requested launch has a 'Start Debug From' attribute.\nLaunching this type of session will terminate and remove any other previous launches.\nDo you wish to continue and launch the new session?"));
                    }
                    if (resultHolder.getResult()) {
                        PHPDebugEPLPlugin.setDisableAutoRemoveLaunches(true);
                        PHPLaunchUtilities.removeAndTerminateOldLaunches(newLaunch);
                    } else {
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(newLaunch);
                    }
                }
            });
            return resultHolder.getResult();
        }
        if (newIsDebugAllPages || newIsStartDebugFrom) {
            PHPDebugEPLPlugin.setDisableAutoRemoveLaunches(true);
        } else {
            PHPDebugEPLPlugin.setDisableAutoRemoveLaunches(!PHPDebugEPLPlugin.getDefault().getInitialAutoRemoveLaunches());
            DebugUIPlugin.getDefault().getLaunchConfigurationManager().launchAdded(newLaunch);
        }
        return true;
    }

    private static void checkAutoRemoveLaunches() {
        if (DebugPlugin.getDefault().getLaunchManager().getLaunches().length == 1) {
            PHPDebugEPLPlugin.setDisableAutoRemoveLaunches(false);
        }
    }

    public static boolean isDebugAllPages(ILaunch launch) throws CoreException {
        String attribute = launch.getAttribute("debugPages");
        return attribute != null && attribute.equals("debugAllPages");
    }

    public static boolean isStartDebugFrom(ILaunch launch) throws CoreException {
        String attribute = launch.getAttribute("debugPages");
        return attribute != null && attribute.equals("debugFrom");
    }

    public static boolean checkIsStandardPort(String debuggerID) {
        IPreferenceStore store = PHPDebugEPLPlugin.getDefault().getPreferenceStore();
        String option = store.getString("com.aptana.php.debug.notifyNonStandardPort");
        if ("always".equals(option)) {
            Status warningStatus = null;
            int debugPort = PHPDebugEPLPlugin.getDebugPort(debuggerID);
            if ("org2.eclipse.php.debug.core.xdebugDebugger".equals(debuggerID)) {
                if (!XDebugCommunicationDaemon.isDefaultDebugPort(debugPort)) {
                    warningStatus = new Status(2, "com.aptana.php.debug.epl", 0, NLS.bind((String)PHPDebugCoreMessages.PHPLaunchUtilities_xdebugNonStandardPort, (Object)debugPort), null);
                }
            } else if ("org2.eclipse.php.debug.core.zendDebugger".equals(debuggerID) && !DebuggerCommunicationDaemon.isDefaultDebugPort(debugPort)) {
                warningStatus = new Status(2, "com.aptana.php.debug.epl", 0, NLS.bind((String)PHPDebugCoreMessages.PHPLaunchUtilities_zendDebugNonStandardPort, (Object)debugPort), null);
            }
            if (warningStatus == null) {
                return true;
            }
            Status preferencesMassage = new Status(1, "com.aptana.php.debug.epl", 0, PHPDebugCoreMessages.PHPLaunchUtilities_portSettingsPreferencesPage, null);
            final MultiStatus multiStatus = new MultiStatus("com.aptana.php.debug.epl", 0, new IStatus[]{warningStatus, preferencesMassage}, PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, null);
            final DialogResultHolder resultHolder = new DialogResultHolder();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DebugPortNotificationDialog notificationDialog = new DebugPortNotificationDialog(Display.getDefault().getActiveShell(), PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, null, PHPDebugCoreMessages.PHPLaunchUtilities_nonStandardPort, (IStatus)multiStatus, 2, PHPDebugCoreMessages.PHPLaunchUtilities_doNotShowThisAgain, false);
                    resultHolder.setReturnCode(notificationDialog.open());
                }
            });
            switch (resultHolder.getReturnCode()) {
                case 10: {
                    return true;
                }
                case -1: 
                case 1: 
                case 7: {
                    return false;
                }
            }
        }
        return true;
    }

    private static void removeAndTerminateOldLaunches(ILaunch newLaunch) {
        ILaunch[] launches;
        ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray = launches = lManager.getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch element = iLaunchArray[n2];
            ILaunch launch = element;
            if (launch != newLaunch) {
                if (!launch.isTerminated()) {
                    try {
                        launch.terminate();
                    }
                    catch (DebugException e) {
                        Logger.logException(e);
                    }
                }
                lManager.removeLaunch(launch);
            }
            ++n2;
        }
    }

    public static boolean shouldBreakOnJitFirstLine(final String remoteIP) {
        final IPreferenceStore store = PHPDebugEPLPlugin.getDefault().getPreferenceStore();
        String option = store.getString("com.aptana.php.debug.breakOnFirstLineForUnknownJIT");
        if ("always".equals(option)) {
            return true;
        }
        if ("prompt".equals(option)) {
            final DialogResultHolder resultHolder = new DialogResultHolder();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PHPLaunchUtilities.getActiveShell();
                    BlinkingMessageDialogWithToggle dialog = new BlinkingMessageDialogWithToggle(shell, PHPDebugCoreMessages.Debugger_incomingDebuggerJitRequestTitle, null, NLS.bind((String)PHPDebugCoreMessages.Debugger_incomingDebuggerJitRequest, (Object[])new Object[]{remoteIP}), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, PHPDebugCoreMessages.PHPLaunchUtilities_rememberDecision, false);
                    dialog.setPrefStore(store);
                    dialog.setPrefKey("com.aptana.php.debug.breakOnFirstLineForUnknownJIT");
                    dialog.open();
                    resultHolder.setReturnCode(dialog.getReturnCode());
                }
            });
            if (resultHolder.getReturnCode() == 2) {
                return true;
            }
        }
        return false;
    }

    public static Shell getActiveShell() {
        IWorkbenchWindow activeWorkbenchWindow;
        Shell shell = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
            shell = activeWorkbenchWindow.getShell();
        }
        if (shell == null) {
            Display current = Display.getCurrent();
            shell = current != null ? current.getActiveShell() : Display.getDefault().getActiveShell();
        }
        return shell;
    }

    public static void showWaitForDebuggerMessage(final DebugConnectionThread debugConnectionThread) {
        if (progressDialog != null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                progressDialog = new DebuggerDelayProgressMonitorDialog();
                if (progressDialog.open() == 1) {
                    debugConnectionThread.closeConnection();
                }
                progressDialog = null;
            }
        });
    }

    public static void hideWaitForDebuggerMessage() {
        if (progressDialog != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (progressDialog != null) {
                        progressDialog.close();
                    }
                }
            });
            progressDialog = null;
        }
    }

    public static void showLaunchErrorMessage() {
        PHPLaunchUtilities.showDebuggerErrorMessage(PHPDebugCoreMessages.Debugger_Launch_Error, PHPDebugCoreMessages.Debugger_Error_Message);
    }

    public static void showLaunchErrorMessage(String errorMessage) {
        PHPLaunchUtilities.showDebuggerErrorMessage(PHPDebugCoreMessages.Debugger_Launch_Error, errorMessage);
    }

    public static void showDebuggerErrorMessage(final String title, final String errorMessage) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)errorMessage);
            }
        });
    }

    public static void openLaunchConfigurationDialog(final ILaunchConfiguration configuration, final String mode) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ILaunchGroup group;
                ILaunchConfiguration conf = configuration;
                try {
                    ILaunchConfiguration underlyingConfig;
                    String underlyingHandle = configuration.getAttribute(DebugUIPlugin.ATTR_LAUNCHING_CONFIG_HANDLE, "");
                    if (underlyingHandle.length() > 0 && (underlyingConfig = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(underlyingHandle)) != null) {
                        conf = underlyingConfig;
                    }
                }
                catch (CoreException coreException) {}
                if ((group = DebugUITools.getLaunchGroup((ILaunchConfiguration)conf, (String)mode)) != null) {
                    DebugUITools.openLaunchConfigurationDialog((Shell)Display.getDefault().getActiveShell(), (ILaunchConfiguration)conf, (String)group.getIdentifier(), null);
                }
            }
        });
    }

    public static String[] getEnvironment(ILaunchConfiguration configuration, String[] additionalEnv) throws CoreException {
        if (additionalEnv == null) {
            additionalEnv = new String[]{};
        }
        Map<String, String> additionalEnvMap = PHPLaunchUtilities.asAttributesMap(additionalEnv);
        String[] totalEnv = null;
        String[] launchConfigurationEnvironment = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        if (launchConfigurationEnvironment != null) {
            Map<String, String> envMap = PHPLaunchUtilities.asAttributesMap(launchConfigurationEnvironment);
            additionalEnvMap.putAll(envMap);
            totalEnv = PHPLaunchUtilities.asAttributesArray(additionalEnvMap);
        } else {
            Map nativeEnvironment = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
            nativeEnvironment.putAll(additionalEnvMap);
            totalEnv = PHPLaunchUtilities.asAttributesArray(nativeEnvironment);
        }
        return totalEnv;
    }

    private static Map<String, String> asAttributesMap(String[] attributesArray) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (attributesArray == null) {
            return map;
        }
        String[] stringArray = attributesArray;
        int n = attributesArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            try {
                int index = attribute.indexOf(61);
                map.put(attribute.substring(0, index), attribute.substring(index + 1));
            }
            catch (Exception e) {
                Logger.logException("Error while parsing launch attribute '" + attribute + '\'', e);
            }
            ++n2;
        }
        return map;
    }

    private static String[] asAttributesArray(Map<String, String> attributesMap) {
        String[] attributes = new String[attributesMap.size()];
        int index = 0;
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            attributes[index++] = String.valueOf(entry.getKey()) + '=' + entry.getValue();
        }
        return attributes;
    }

    public static Map<String, String> getPHPCGILaunchEnvironment(String fileName, String query, String phpConfigDir, String phpExeDir, String[] scriptArguments) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("REQUEST_METHOD", "GET");
        env.put("SCRIPT_FILENAME", fileName);
        env.put("SCRIPT_NAME", fileName);
        env.put("PATH_TRANSLATED", fileName);
        env.put("PATH_INFO", fileName);
        StringBuilder queryStringBuf = new StringBuilder(query);
        queryStringBuf.append("&debug_host=127.0.0.1");
        if (scriptArguments != null) {
            String[] stringArray = scriptArguments;
            int n = scriptArguments.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                queryStringBuf.append('&').append(arg);
                ++n2;
            }
        }
        env.put("QUERY_STRING", queryStringBuf.toString());
        env.put("REDIRECT_STATUS", "1");
        env.put("PHPRC", phpConfigDir);
        PHPLaunchUtilities.appendLibrarySearchPathEnv(env, new File(phpExeDir));
        return env;
    }

    public static void appendLibrarySearchPathEnv(Map<String, String> env, File phpExeDir) {
        String variable = PHPLaunchUtilities.getLibrarySearchEnvVariable();
        if (variable == null) {
            return;
        }
        String value = PHPLaunchUtilities.getLibrarySearchEnvValue(variable, phpExeDir, false);
        env.put(variable, value);
    }

    private static String getLibrarySearchEnvValue(String variable, File phpExeDir, boolean quoted) {
        StringBuilder buf = new StringBuilder();
        File libDirectory = new File(phpExeDir.getParentFile(), "lib");
        if (libDirectory.exists()) {
            buf.append(PHPLaunchUtilities.createPath(libDirectory, quoted));
        } else {
            buf.append(PHPLaunchUtilities.createPath(phpExeDir, quoted));
        }
        try {
            String env = System.getenv(variable);
            if (env != null) {
                buf.append(File.pathSeparatorChar).append(env);
            }
        }
        catch (Throwable throwable) {}
        return buf.toString();
    }

    private static String createPath(File path, boolean quoted) {
        return quoted ? String.valueOf('\"') + path.getAbsolutePath() + '\"' : path.getAbsolutePath();
    }

    private static String getLibrarySearchEnvVariable() {
        if (!"win32".equals(Platform.getOS())) {
            if ("macosx".equals(Platform.getOS())) {
                return "DYLD_LIBRARY_PATH";
            }
            return "LD_LIBRARY_PATH";
        }
        return null;
    }

    public static String getLibrarySearchPathEnv(File phpExeDir, boolean quoted) {
        String variable = PHPLaunchUtilities.getLibrarySearchEnvVariable();
        if (variable == null) {
            return null;
        }
        String value = PHPLaunchUtilities.getLibrarySearchEnvValue(variable, phpExeDir, quoted);
        return variable + '=' + value;
    }

    public static String getLibrarySearchPathEnv(File phpExeDir) {
        return PHPLaunchUtilities.getLibrarySearchPathEnv(phpExeDir, false);
    }

    public static String[] getCommandLine(ILaunchConfiguration configuration, String phpExe, String phpConfigDir, String scriptPath, String[] args) throws CoreException {
        String aspTags = PHPLaunchUtilities.isUsingASPTags(PHPLaunchUtilities.getProject(configuration)) ? "on" : "off";
        LinkedList<String> cmdLineList = new LinkedList<String>();
        cmdLineList.addAll(Arrays.asList(phpExe, "-c", phpConfigDir, "-d", "asp_tags=" + aspTags, scriptPath));
        if (args != null) {
            cmdLineList.addAll(Arrays.asList(args));
        }
        return cmdLineList.toArray(new String[cmdLineList.size()]);
    }

    private static IProject getProject(ILaunchConfiguration configuration) {
        try {
            String fileNameString = ScriptLocator.getScriptFile((ILaunchConfiguration)configuration);
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path filePath = new Path(fileNameString);
            IResource res = workspaceRoot.findMember((IPath)filePath);
            if (res != null) {
                return res.getProject();
            }
        }
        catch (CoreException ce) {
            Logger.logException(ce);
        }
        return null;
    }

    public static String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String arguments = configuration.getAttribute("exeDebugArguments", null);
        if (arguments == null || arguments.trim().equals("")) {
            return new String[0];
        }
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments).split(" ");
    }

    public static boolean isUsingASPTags(IProject project) {
        return false;
    }

    public static String generateQuery(ILaunch launch, IDebugParametersInitializer debugParametersInitializer) {
        StringBuffer buf = new StringBuffer();
        Hashtable<String, String> parameters = debugParametersInitializer.getDebugParameters(launch);
        Enumeration<String> e = parameters.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            buf.append(key).append('=');
            try {
                buf.append(URLEncoder.encode(parameters.get(key), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            if (!e.hasMoreElements()) continue;
            buf.append('&');
        }
        return buf.toString();
    }

    public static IWebBrowser openInternalBrowser(String browserTitle) throws PartInitException {
        int browserStyle = 78;
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        IWebBrowser browser = null;
        if (browserSupport.isInternalWebBrowserAvailable()) {
            int currentBrowserChoice = WebBrowserPreference.getBrowserChoice();
            if (currentBrowserChoice == 1) {
                WebBrowserPreference.setBrowserChoice((int)0);
                browser = PHPLaunchUtilities.getBrowser(browserSupport, browserStyle, browserTitle);
                WebBrowserPreference.setBrowserChoice((int)1);
            } else {
                browser = PHPLaunchUtilities.getBrowser(browserSupport, browserStyle, browserTitle);
            }
        } else {
            browser = PHPLaunchUtilities.getBrowser(browserSupport, browserStyle, browserTitle);
        }
        return browser;
    }

    private static IWebBrowser getBrowser(IWorkbenchBrowserSupport browserSupport, int browserStyle, String browserTitle) throws PartInitException {
        return browserSupport.createBrowser(browserStyle, "PHPDebuggerBrowser", browserTitle, browserTitle);
    }

    public static void openInternalBrowserView(final String url) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    IViewPart viewPart = window.getActivePage().showView("org.eclipse.ui.browser.view");
                    if (viewPart instanceof WebBrowserView) {
                        ((WebBrowserView)viewPart).setURL(url);
                    }
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static int getDebugPort(ILaunchConfiguration launchConfiguration) {
        try {
            String debuggerID = launchConfiguration.getAttribute("com.aptana.php.debug.php_debugger_id", PHPDebugEPLPlugin.getCurrentDebuggerId());
            AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration(debuggerID);
            return debuggerConfiguration.getPort();
        }
        catch (Exception e) {
            PHPDebugEPLPlugin.logError("Could not retrieve the debugger's port number", e);
            return -1;
        }
    }

    public static String getDebugHost(ILaunchConfiguration launchConfiguration) {
        String url;
        block4: {
            url = launchConfiguration.getAttribute("ATTR_SERVER_BASE_URL", "");
            if (url != null && url.length() != 0) break block4;
            return null;
        }
        try {
            return new URL(url).getHost();
        }
        catch (CoreException e) {
            PHPDebugEPLPlugin.logError("Could not retrieve the host name", e);
        }
        catch (MalformedURLException e) {
            PHPDebugEPLPlugin.logError("Could not retrieve the host name", e);
        }
        return null;
    }

    public static SSHTunnel getSSHTunnel(ILaunchConfiguration configuration) {
        try {
            if (configuration.getAttribute("org2.eclipse.php.debug.core.UseSSHTunnel", false)) {
                String remoteHost = PHPLaunchUtilities.getDebugHost(configuration);
                int port = PHPLaunchUtilities.getDebugPort(configuration);
                if (remoteHost != null && remoteHost.length() > 0 && port > -1) {
                    String userName = configuration.getAttribute("org2.eclipse.php.debug.core.SSHTunnelUserName", "");
                    String password = PHPLaunchUtilities.getSecurePreferences(remoteHost).get(userName, "");
                    return SSHTunnelFactory.getSSHTunnel((String)remoteHost, (String)userName, (String)password, (int)port, (int)port);
                }
            }
        }
        catch (CoreException e) {
            PHPDebugEPLPlugin.logError("Error obtaining an SSHTunnel instance", e);
        }
        catch (StorageException e) {
            PHPDebugEPLPlugin.logError("Error accessing the secured storage for the debug SSH tunnel", e);
        }
        return null;
    }

    static class BlinkingMessageDialogWithToggle
    extends MessageDialogWithToggle {
        public BlinkingMessageDialogWithToggle(Shell parentShell, String dialogTitle, Image image, String message, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String toggleMessage, boolean toggleState) {
            super(parentShell, dialogTitle, image, message, dialogImageType, dialogButtonLabels, defaultIndex, toggleMessage, toggleState);
            if (parentShell != null && !parentShell.isFocusControl()) {
                parentShell.setMinimized(false);
                parentShell.forceActive();
            }
        }
    }

    private static class DebuggerDelayProgressMonitorDialog
    extends ProgressMonitorDialog {
        public DebuggerDelayProgressMonitorDialog() {
            super(null);
            this.setBlockOnOpen(true);
            this.setCancelable(true);
        }

        protected void createCancelButton(Composite parent) {
            this.cancel = this.createButton(parent, 1, PHPDebugCoreMessages.PHPLaunchUtilities_terminate, true);
            if (this.arrowCursor == null) {
                this.arrowCursor = new Cursor((Device)this.cancel.getDisplay(), 0);
            }
            this.cancel.setCursor(this.arrowCursor);
            this.setOperationCancelButtonEnabled(this.enableCancelButton);
        }

        protected Control createDialogArea(Composite parent) {
            Control c = super.createDialogArea(parent);
            this.getProgressMonitor().beginTask(PHPDebugCoreMessages.PHPLaunchUtilities_waitingForDebugger, -1);
            return c;
        }
    }

    private static class DialogResultHolder {
        private int returnCode;
        private boolean result;

        private DialogResultHolder() {
        }

        public boolean getResult() {
            return this.result;
        }

        public void setResult(boolean result) {
            this.result = result;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public void setReturnCode(int returnCode) {
            this.returnCode = returnCode;
        }
    }

    private static class PerspectiveTracker
    extends PerspectiveAdapter {
        IPerspectiveDescriptor currentPerspective;
        IPerspectiveDescriptor previousPerspective;
        boolean initialized;
        boolean isTracking;

        public PerspectiveTracker() {
            this.setTracking(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTracking(boolean track) {
            PerspectiveTracker perspectiveTracker = this;
            synchronized (perspectiveTracker) {
                if (track == this.isTracking) {
                    return;
                }
                this.isTracking = track;
                if (this.isTracking) {
                    this.initialize();
                    this.currentPerspective = this.getCurrentPerspective();
                    this.previousPerspective = null;
                } else {
                    this.currentPerspective = null;
                    this.previousPerspective = null;
                }
            }
        }

        public void reset() {
            this.currentPerspective = null;
            this.previousPerspective = null;
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (this.isTracking) {
                this.previousPerspective = this.currentPerspective;
                this.currentPerspective = perspective;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize() {
            PerspectiveTracker perspectiveTracker = this;
            synchronized (perspectiveTracker) {
                if (!this.initialized) {
                    IWorkbenchWindow activeWorkbenchWindow = this.getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow != null) {
                        activeWorkbenchWindow.addPerspectiveListener((IPerspectiveListener)this);
                        this.initialized = true;
                    } else {
                        PHPDebugEPLPlugin.logError("Failed to register a perspective change listener for the PHP debug. \nThe active workbench window was null");
                    }
                }
            }
        }

        private IWorkbenchWindow getActiveWorkbenchWindow() {
            final IWorkbenchWindow[] window = new IWorkbenchWindow[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    window[0] = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                }
            });
            return window[0];
        }

        public IPerspectiveDescriptor getCurrentPerspective() {
            IWorkbenchPage activePage;
            IWorkbenchWindow activeWorkbenchWindow = this.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
                return activePage.getPerspective();
            }
            return null;
        }

        public IPerspectiveDescriptor getPreviousPerspective() {
            this.initialize();
            return this.previousPerspective;
        }
    }
}

